;******************************************************
;******************************************************
;
; Main Project     : OCRG
; Project Name     : OCRG CWVM - CW Voltmeter
; File Name        : hardware.asm
; Version          : A03
; PIC Used         : PIC12HV615
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : Nov 19, 2009
; Last Update date : Dec 22, 2009
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
; Copyright 2009   : WA7ZVY
;
;******************************************************
;
; These routines deal with hardware specific details.
;
;	1) Initializing the hardware
;	2) Processing Timer 0 interrupts
;	3) Processing Timer 1 interrupts
;	4) Processing Timer 2 interrupts
;
;******************************************************
;
; 	Function List (in top-2-bottom order):
;		void init_hardware(void);
;		void timer0_irq_service(void);
;		void timer1_irq_service(void);
;		void timer2_irq_service(void);
;
;******************************************************
;
;   Modification History:
;   =-=-=-=-=-=-=-=-=-=-=
;   11-19-09 pm - Initial creation.
;
;*****************************************************
;   === Include files ===
;*****************************************************
 	LIST   P=12HV615			;List directive to define processor

#include	P12HV615.INC		;Processor specific variable definitions
#include	constants.inc		;Coding constants
#include	micro_bits.inc		;Hardware defined bits
#include	variable_def.inc	;Variable definitions


HARDWARE_CODE	CODE				;hardware code space

;*****************************************************
;*****************************************************
;
;	Name:		init_hardware
;	
;	Abstract:
;	This is the cold start CWVM hardware initialization
;	code. It is called by main as the first thing. The
;	presumption is that this code is executed whenever
;	the CWVM microcontroller is released from reset.
;
;	Callable Routines:
		global	init_hardware
;
;	Called Routines:  None.
;
;	Global Variables Used:  None.
;		
;	Local Variables Used:  None.
;	
;	Return Values:	None.
;		
;*****************************************************
;*****************************************************
init_hardware
	movlw	0x00			;Turn off ALL of the various interrupts, should be done by
	movwf	INTCON			; reset, but just do it to be sure
	banksel	BANK1
	movwf	PIE1

; Initialize the I/O pins (GPIO5, GPIO4, GPIO3, GPIO1, GPIO0 as inputs; GPIO2 as output)
	banksel	BANK0
	movlw	CFG_GPIO		;Set the state of the pins
	movwf	GPIO
	banksel	BANK1
	movlw	CFG_TRISIO		;Set the direction of the pins
	movwf	TRISIO
	movlw	CFG_WPU			;Turn on the weak pullups on GPIO5, GPIO3, GPIO1
	movwf	WPU
	movlw	CFG_OPTION		;Enable the weak pullups, Timer 0 Prescaler, Timer 0 clock source
	movwf	OPTION_REG

; Setup the Analog to Digital Converter
	movlw	CFG_ANSEL		;FRC, GPIO4 as analog, GPIO0 as analog
	movwf	ANSEL

	banksel	BANK0

; Clear any interrupt flags
	movlw	CFG_PIR1
	movwf	PIR1

; Initialized Timer 0 for the CW tone frequency generation
	movlw	MORSE_TONE
	movwf	TMR0

; Initialize Timer 2 registers for use with the dit amount of time delay generation
	clrf	TMR2
	banksel	BANK1
	movlw	0xff
	movwf	PR2

	banksel	BANK0

	return




;*****************************************************
;*****************************************************
;
;	Name:		timer0_irq_service
;	
;	Abstract:
;	This routine services the timer 0 interrupts.
;
;	Timer 0:
;	a). Used for Tone Generation. The Timer 0 is set to generate
;		an interrupt whenever the output waveform needs to advance to
;		the next state.
;
;	Callable Routines:
		global	timer0_irq_service
;
;	Called Routines:  None.
;		
;	Global Variables Used:  None.
;
;	Local Variables:  None.
;	
;	Return Values:	None.
;		
;*****************************************************
;*****************************************************
timer0_irq_service
	banksel	BANK0
	movf	b0_ToneOn,F			;Check to see if the Tone is currently On
	btfsc	STATUS,Z
	goto	t0is_2				;The Tone is Off so go set the pin to "0" to keep from burning power

; The Tone is On, so toggle the GPIO pin's state at each timer0 interrupt.
; Also maintain and use a copy of the current ToneState.
	movf	b0_ToneState,F		;Check if the Tone's output is currently high or low
	btfsc	STATUS,Z
	goto	t0is_1
	clrf	b0_ToneState		;It was a "1", so set it to "0"
	bcf		GPIO,GPIO2
	goto	t0is_3

t0is_1
	bsf		b0_ToneState,TRUE	;It was a "0", so set it to "1"
	bsf		GPIO,GPIO2
	goto	t0is_3

t0is_2
	clrf	b0_ToneState		;The tone is off, so set the pin to "0" to reduce power consumption
	bcf		GPIO,GPIO2

t0is_3
; Update timer tick count and clear interrupt flag
	banksel	BANK0
	movlw	MORSE_TONE
	movwf	TMR0
	bcf		INTCON,T0IF

	return



	end
; End of File (hardware.asm)
