;***********************************************************************
;***********************************************************************
;
; Main Project     : OCRG
; Project Name     : OCRG CWVM - CW Voltmeter
; File Name        : micro_bits.inc
; Version          : A03
; PIC Used         : PIC12HV615
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : Nov 19, 2009
; Last Update date : Dec 22, 2009
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
; Copyright 2009   : WA7ZVY
;
;**********************************************************************
;
;	Modification History:
;	=-=-=-=-=-=-=-=-=-=-=
;	11-19-09 pm - Initial creation.
;	
;***********************************************************************
;***********************************************************************

;Register Configurations
;
;***********************************************************************
;	=== GPIO REGISTERS ===
;***********************************************************************
#define	CFG_GPIO	0x3B		;Addr 0x05	
;												:7: N/A, <reads as 0>
;												:6: N/A, <reads as 0>
;												:5: high <not used>
;												:4: high <ADC analog input, Voltmeter>
;												:3: high <not used, /MCLR pin>
;												:2: low  <speaker drive>
;												:1: high <not used, ICSPCLK pin>
;												:0: high <ADC analog input, Code Speed, ICSPDATA pin>
;***********************************************************************
#define	CFG_OPTION	0x02		;Addr 0x81
;												:7: GPIO pullups enabled - see WPU bits>
;												:6: <not used, see INTCON register>
;												:5: TMR0 clock source - internal clk
;												:4: <not used, see bit 5>
;												:3: PSA - prescaler assigned to Timer0
;												:2: PRESCALER = 1:8
;												:1: PRESCALER = 1:8
;												:0: PRESCALER = 1:8
;***********************************************************************
#define	CFG_TRISIO	0xFB		;Addr 0x85
;												:7: input  <N/A>
;												:6: input  <N/A>
;												:5: input  <not used>
;												:4: input  <ADC analog input, Voltmeter>
;												:3: input  <input only, not used, /MCLR pin>
;												:2: output <speaker drive, output>
;												:1: input  <not used, ICSPCLK pin>
;												:0: input  <ADC analog input, Code Speed, ICSPDATA pin>
;***********************************************************************
#define	CFG_WPU		0x2A		;Addr 0x95
;												:7: N/A
;												:6: N/A
;												:5: on  <not used>
;												:4: off <ADC analog input, Voltmeter>
;												:3: on  <not used, /MCLR pin>
;												:2: off <speaker drive, output>
;												:1: on  <not used, ICSPCLK pin>
;												:0: off <ADC analog input, Code Speed, ICSPDATA pin>
;***********************************************************************
#define	CFG_ANSEL	0x39		;Addr 0x9F
;												:7: N/A
;												:6: FRC <ADCS2>
;												:5: FRC <ADCS1>
;												:4: FRC <ADCS0>
;												:3: analog  function on GPIO4 <ANS3>
;												:2: digital function on GPIO2 <ANS2>
;												:1: digital function on GPIO1 <ANS1>
;												:0: analog  function on GPIO0 <ANS0>
;***********************************************************************



;***********************************************************************
#define	CFG_INTCON	0xE0		;Addr 0x0B
;												:7: Enable ALL Interrupts
;												:6: Enable Peripheral Interrupts
;												:5: Enable TMR0 Overflow Interrupt
;												:4: Disable GP2/INT Interrupt
;												:3: Disable GPIO Change Interrupt
;												:2: TMR0 Overflow Flag
;												:1: GP2/INT Flag
;												:0: GPIO Change Flag
;***********************************************************************
#define	CFG_PIR1	0x00		;Addr 0x0C
;												:7: N/A, reads as 0
;												:6: Clears ADIF
;												:5: Clears CCP1IF
;												:4: N/A, reads as 0
;												:3: Clears CMIF
;												:2: N/A, reads as 0
;												:1: Clears TMR2IF
;												:0: Clears TMR1IF
;***********************************************************************
#define	CFG_T2CON	0x7A		;Addr 0x12
;												:7: <Not used, Reads as 0>
;												:6: Postscaler <16>
;												:5: Postscaler <16>
;												:4: Postscaler <16>
;												:3: Postscaler <16>
;												:2: Timer 2 OFF/ON
;												:1: Prescaler <16>
;												:0: Prescaler <16>
;***********************************************************************
#define	CFG_ADCON0_OFF	0x80	;Addr 0x1F
;												:7: right justify ADC value <ADFM>
;												:6: Vdd voltage reference <VCFG>
;												:5: N/A, reads as 0
;												:4: ADC channel 0 <CHS2>
;												:3: ADC channel 0 <CHS1>
;												:2: ADC channel 0 <CHS0>
;												:1: ADC start/status <GO/DONE>
;												:0: ADC enable <ADON>
;***********************************************************************
#define	CFG_ADCON0_CH0	0x81	;Addr 0x1F
;												:7: right justify ADC value <ADFM>
;												:6: Vdd voltage reference <VCFG>
;												:5: N/A, reads as 0
;												:4: ADC channel 0 <CHS2>
;												:3: ADC channel 0 <CHS1>
;												:2: ADC channel 0 <CHS0>
;												:1: ADC start/status <GO/DONE>
;												:0: ADC enable <ADON>
;***********************************************************************
#define	CFG_ADCON0_CH1	0x85	;Addr 0x1F
;												:7: right justify ADC value <ADFM>
;												:6: Vdd voltage reference <VCFG>
;												:5: N/A, reads as 0
;												:4: ADC channel 1 <CHS2>
;												:3: ADC channel 1 <CHS1>
;												:2: ADC channel 1 <CHS0>
;												:1: ADC start/status <GO/DONE>
;												:0: ADC enable <ADON>
;***********************************************************************
#define	CFG_ADCON0_CH2	0x89	;Addr 0x1F
;												:7: right justify ADC value <ADFM>
;												:6: Vdd voltage reference <VCFG>
;												:5: N/A, reads as 0
;												:4: ADC channel 2 <CHS2>
;												:3: ADC channel 2 <CHS1>
;												:2: ADC channel 2 <CHS0>
;												:1: ADC start/status <GO/DONE>
;												:0: ADC enable <ADON>
;***********************************************************************
#define	CFG_ADCON0_CH3	0x8D	;Addr 0x1F
;												:7: right justify ADC value <ADFM>
;												:6: Vdd voltage reference <VCFG>
;												:5: N/A, reads as 0
;												:4: ADC channel 3 <CHS2>
;												:3: ADC channel 3 <CHS1>
;												:2: ADC channel 3 <CHS0>
;												:1: ADC start/status <GO/DONE>
;												:0: ADC enable <ADON>
;***********************************************************************
#define	CFG_ADCON0_V06	0x95	;Addr 0x1F
;												:7: right justify ADC value <ADFM>
;												:6: Vdd voltage reference <VCFG>
;												:5: N/A, reads as 0
;												:4: ADC channel Vref 0.6V <CHS2>
;												:3: ADC channel Vref 0.6V <CHS1>
;												:2: ADC channel Vref 0.6V <CHS0>
;												:1: ADC start/status <GO/DONE>
;												:0: ADC enable <ADON>
;***********************************************************************
#define	CFG_ADCON0_V12	0x99	;Addr 0x1F
;												:7: right justify ADC value <ADFM>
;												:6: Vdd voltage reference <VCFG>
;												:5: N/A, reads as 0
;												:4: ADC channel Vref 1.2V <CHS2>
;												:3: ADC channel Vref 1.2V <CHS1>
;												:2: ADC channel Vref 1.2V <CHS0>
;												:1: ADC start/status <GO/DONE>
;												:0: ADC enable <ADON>
;***********************************************************************
#define	CFG_PIE1	0x00		;Addr 0x8C
;												:7: N/A reads as 0
;												:6: Disables ADC Interrupt (ADIE)
;												:5: Disables Capture Compare 1 Interrupt (CCP1IE)
;												:4: N/A reads as 0
;												:3: Disables Comparator Interrupt (CMIE)
;												:2: N/A reads as 0
;												:1: Disables Timer2 to PR2 Match Interrupt (TMR2IE)
;												:0: Disables Timer1 Overflow Interrupt (TMR1IE)
;***********************************************************************
#define	CFG_PCON	0x00		;Addr 0x8E
;												:7: <undefined>
;												:6: <undefined>
;												:5: <undefined>
;												:4: <undefined>
;												:3: <undefined>
;												:2: <undefined>
;												:1: Power On Reset Occurred (POR)
;												:0: Brown Out Reset Occurred (BOR)
;***********************************************************************


;End of File (micro_bits.inc)
