;**********************************************************************
;******************************************************
;******************************************************
;
; Main Project     : OCRG
; Project Name     : OCRG CWVM - CW Voltmeter
; File Name        : variable_def.inc
; Version          : A03
; PIC Used         : PIC12HV615
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : Nov 19, 2009
; Last Update date : Dec 22, 2009
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
; Copyright 2009   : WA7ZVY
;
;******************************************************
;
;   Modification History:
;   =-=-=-=-=-=-=-=-=-=-=
;   11-19-09 pm - Initial creation.
;
;**********************************************************************
; VARIABLE DEFINITIONS
;*****************************************************
; Shared Uninitialized Data Section

	cblock	0x70	      	; duplicated in both banks:
							;  0x70-0x7F, 0xF0-0xFF

;	***** TOTAL LOCATIONS = 16, LOCATIONS USED = 13, LOCATIONS REMAINING =  3 *****

	w_temp					; variable used for context saving 
	status_temp				; variable used for context saving
	pclath_temp				; variable used for context saving

	arg1_wrd: 0, arg1_hi, arg1_lo	;variable used for passing arguments to called routines
	arg2_wrd: 0, arg2_hi, arg2_lo	;variable used for passing arguments to called routines
	arg3_wrd: 0, arg3_hi, arg3_lo	;variable used for passing arguments to called routines
	arg4_wrd: 0, arg4_hi, arg4_lo	;variable used for passing arguments to called routines
	arg5_wrd: 0, arg5_hi, arg5_lo	;variable used for passing arguments to called routines

	endc

;*****************************************************
; Uninitialized Data Section

	cblock	0x40

	;Dummy register name to use when setting bank 0 access
	bank_0_gpr: 0

;	***** TOTAL LOCATIONS = 48, LOCATIONS USED = 20, LOCATIONS REMAINING = 28 *****

	;Global variables
	b0_ToneOn
	b0_ToneState
	b0_OverRange
	b0_nibbles_wrd: 0, b0_nibbles_hi, b0_nibbles_lo

	;Local variables
	b0_tmp1_wrd: 0, b0_tmp1_hi, b0_tmp1_lo
	b0_tmp2_wrd: 0, b0_tmp2_hi, b0_tmp2_lo
	b0_tmp3_wrd: 0, b0_tmp3_hi, b0_tmp3_lo
	b0_tmp4_wrd: 0, b0_tmp4_hi, b0_tmp4_lo
	b0_tmp5_wrd: 0, b0_tmp5_hi, b0_tmp5_lo

	b0_tmp1_counter
	b0_tmp1_index
	b0_correction_wrd: 0, b0_correction_hi, b0_correction_lo
	b0_correct_negative

	endc
;*****************************************************



;**********************************************************************

;End of File (variable_def.inc)