;******************************************************
;******************************************************
;
; Main Project     : VFOpm
; Project Name     : VFOpm - Digital Variable Frequency Oscillator
; File Name        : constants.inc
; Version          : A01
; PIC Used         : PIC16F648A
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : Nov. 4, 2014
; Last Update date : Nov. 4, 2014
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
;
;******************************************************
;
;	Modification History:
;	=-=-=-=-=-=-=-=-=-=-=
;	20141104 pm - Initial creation.
;
;***********************************************************************
;          == Conditional Compile Switches ===
;***********************************************************************
;
;
;***********************************************************************
; General definitions
#define	TRUE	0x01
#define	FALSE	0x00
#define	YES		0x01
#define	NO		0x00
#define	BANK0	0x00
#define	BANK1	0x80
#define	BANK2	0x100
#define	BANK3	0x180
;***********************************************************************
; System definitions
;
;***********************************************************************

; Zero VFO frequency in hex (this is for 5.00MHz)
;#define	t4		0x1f	;msb of custom vfo frequency
;#define	t3		0xff	;
;#define	t2		0xff	;
;#define	t1		0xfe	;lsb of custom vfo frequency (here it is 5.05MHz)

; Zero VFO frequeny in hex (this is for 5.05MHz)
;#define	t4		0x20	;msb of custom vfo frequency
;#define	t3		0x51	;
;#define	t2		0xeb	;
;#define	t1		0x85	;lsb of custom vfo frequency (here it is 5.05MHz)

; Bump STEP direction (determines rotation direction for step bumping)
#define	UP		0x01
#define	DOWN	0x02
;#define	BUMPDIR	UP
#define	BUMPDIR	DOWN

; LCD Display Types
#define	VARITRONICS	0x01	;Uses ??? controller
#define	LUMEX		0x02	;Uses a Samsung S6A0069 controller

; LCD Type Used in this hardware
;#define	LCD_TYPE	VARITRONICS
#define	LCD_TYPE	LUMEX


; HARRIS DDS Commands via the DDS Latch:
;	Bit 7 = ~SEL_L/M	always high
;	Bit 6 = ~SFTEN		low when shifting in data
;	Bit 5 = ~MSB/LSB	always high
;	Bit 4 = ~LOAD		always high
;	Bit 3 = ~ENPHAC		low to generate output
;	Bit 2 = ~TXFR		pulse low to load a new frequency
;	Bit 1 = SD			data bit, high or low
;	Bit 0 = SCLK		clock "SD" in on rising edge

#define	DDS_OFF	0xfc	;Output off Command to Harris DDS
#define	DDS_ON	0xf4	;Output on Command to Harris DDS
#define	XFER	0xf0	;Transfer Command to Harris DDS
#define	DAT1	0xb6	;Data bit = 1 to Harris DDS
#define	DAT0	0xb4	;Data bit = 0 to Harris DDS
#define	SCLK_HI	0x01	;Clock bit is the 0 bit to Harris DDS
#define	SCLK_LO	0xfe	;Clock bit is the 0 bit to Harris DDS
#define	LCNT	0x20	;Length of all Harris DDS commands (32 bits)

;***********************************************************************

;***********************************************************************
; Special compile switches:

;***********************************************************************

;End of File (constants.inc)
