;***********************************************************************
;***********************************************************************
;
; Main Project     : VFOpm
; Project Name     : VFOpm - Digital Variable Frequency Oscillator
; File Name        : micro_bits.inc
; Version          : A01
; PIC Used         : PIC16F648A
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : Nov. 4, 2014
; Last Update date : Nov. 4, 2014
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
;
;**********************************************************************
;
;	Modification History:
;	=-=-=-=-=-=-=-=-=-=-=
;	20141104 pm - Initial creation.
;	
;***********************************************************************
;***********************************************************************

;Register Configurations
;
;***********************************************************************
;	=== I/O REGISTERS ===
;***********************************************************************
#define	CFG_PORTA	0x00		;Addr 0x05	
;												:7: low  <CLK to LCD Pre-Register>
;												:6: low  <CLK to DDS Pre-Register>
;												:5: low  <NC>
;												:4: low  <~STORE_BASE>
;												:3: low  <~VFO_MODE>
;												:2: low  <B input from Tune Knob>
;												:1: low  <A input from Tune Knob>
;												:0: low  <SW input from Tune Knob>
;***********************************************************************
#define	CFG_TRISA	0x1f		;Addr 0x85
;												:7: output  <CLK to LCD Pre-Register>
;												:6: output  <CLK to DDS Pre-Register>
;												:5: output  <NC>
;												:4: input   <~STORE_BASE>
;												:3: input   <~VFO_MODE>
;												:2: input   <B input from Tune Knob>
;												:1: input   <A input from Tune Knob>
;												:0: input   <SW input from Tune Knob>
;***********************************************************************
#define	CFG_PORTB	0x00		;Addr 0x06	
;												:7: low  <Data bus D7>
;												:6: low  <Data bus D6>
;												:5: low  <Data bus D5>
;												:4: low  <Data bus D4>
;												:3: low  <Data bus D3>
;												:2: low  <Data bus D2>
;												:1: low  <Data bus D1>
;												:0: low  <Data bus D0>
;***********************************************************************
#define	CFG_TRISB	0x00		;Addr 0x86
;												:7: output  <Data bus D7>
;												:6: output  <Data bus D6>
;												:5: output  <Data bus D5>
;												:4: output  <Data bus D4>
;												:3: output  <Data bus D3>
;												:2: output  <Data bus D2>
;												:1: output  <Data bus D1>
;												:0: output  <Data bus D0>
;***********************************************************************
;***********************************************************************
#define	CFG_INTCON	0x00		;Addr 0x0B
;												:7: <GIE -  Disable ALL Interrupts>
;												:6: <PEIE - Disable Peripheral Interrupts>
;												:5: <T0IE - Disable TMR0 Overflow Interrupt>
;												:4: <INTE - Disable External INT>
;												:3: <RBIE - Disable RB Change Interrupt>
;												:2: <T0IF - TMR0 Overflow Flag>
;												:1: <INTF - External INT Flag>
;												:0: <RBIF - Port B Change Flag>
;***********************************************************************
#define	CFG_PIR1	0x00		;Addr 0x0C
;												:7: Clears PSPIF
;												:6: Clears ADIF
;												:5: Clears RCIF
;												:4: Clears TXIF
;												:3: Clears SSPIF
;												:2: Clears CCP1IF
;												:1: Clears TMR2IF
;												:0: Clears TMR1IF
;***********************************************************************
#define	CFG_PIE1	0x00		;Addr 0x8C
;												:7: Disables EE Write Complete Interrupt (EEIE)
;												:6: Disables Comparator Interrupt (CMIE)
;												:5: Disables USART RxD Interrupt (RCIE)
;												:4: Disables USART TxD Interrupt (TXIE)
;												:3: <undefined>
;												:2: Disables Capture Compare 1 Interrupt (CCP1IE)
;												:1: Disables Timer2 to PR2 Match Interrupt (TMR2IE)
;												:0: Disables Timer1 Overflow Interrupt (TMR1IE)
; ***********************************************************************
#define	CFG_CMCON	0x07		;Addr 0x1F
;												:7: low  <C2OUT>
;												:6: low  <C1OUT>
;												:5: low  <C2INV>
;												:4: low  <C1INV>
;												:3: low  <CIS>
;												:2: high <CM2> must be high to select digital I/O on PortA
;												:1: high <CM1> must be high to select digital I/O on PortA
;												:0: high <CM0> must be high to select digital I/O on PortA
;***********************************************************************
#define	CFG_OPTION	0x80		;Addr 0x81
;												:7: <PORT B Pull-ups Disable>
;												:6: <INTEDG, Not Used, Falling Edge>
;												:5: <T0CS clock source, Not Used, - internal clk>
;												:4: <T0SE source edge, Not Used - rising>
;												:3: <PSA, Not Used - prescaler assigned to Timer0>
;												:2: <PRESCALER, Not Used = 1:2>
;												:1: <PRESCALER, Not Used = 1:2>
;												:0: <PRESCALER, Not Used = 1:2>
;***********************************************************************
#define	CFG_PCON	0x08		;Addr 0x8E
;												:7: <undefined>
;												:6: <undefined>
;												:5: <undefined>
;												:4: <undefined>
;												:3: Oscillator Frequency 1=4MHz, 0=37KHz
;												:2: <undefined>
;												:1: Power On Reset Occurred (POR)
;												:0: Brown Out Reset Occurred (BOR)
;***********************************************************************
;***********************************************************************
;End of File (micro_bits.inc)
