;******************************************************
;******************************************************
;
; Main Project     : VFOpm
; Project Name     : VFOpm - Digital Variable Frequency Oscillator
; File Name        : utilities.asm
; Version          : A01
; PIC Used         : PIC16F648A
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : Nov. 4, 2014
; Last Update date : Nov. 4, 2014
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
;
;******************************************************
;
; Description of this code:
;
; These routines provide various utility functions.
;
;******************************************************
;
;   Modification History:
;   =-=-=-=-=-=-=-=-=-=-=
;   20141104 pm - Initial creation.
;
;******************************************************
;******************************************************
;
;******************************************************
;   === Include files ===
;******************************************************
	LIST   P=16F648A			;List directive to define processor

#include	P16F648A.INC		;Processor specific variable definitions
#include	constants.inc		;Coding constants
#include	micro_bits.inc		;Hardware defined bits
#include	variable_def.inc	;Variable definitions


UTILITIES_CODE	CODE				;utilities code space

;*****************************************************
;
;	Name:		delay_50uSec
;	
;	Abstract:	This routine sits around and delays for
;					50 microseconds.
;
;	Callable Routines:
		global	delay_50uSec
;
;	Called Routines:  None.
;
;	Global Variables Used:  None.
;
;	Local Variables Used:
;		b0_tmp1_lo contains count up counter byte 0
;
;	Return Values:
;
;		
;*****************************************************
;*****************************************************

delay_50uSec					;4.00MHz clock/4  = 1000ns/cpu cycle
	clrf	b0_tmp1_lo			;1 cycle + the call = 3 cycles
	bsf		b0_tmp1_lo,4		;1 cycle
d50us_1
	decfsz	b0_tmp1_lo,F		;1 cycle
	goto	d50us_1				;2 cycles / => 16 loops x 3 cycles each = 48uSec
	return						;2 cycles / => total = 54uSec




;*****************************************************
;*****************************************************
;
;	Name:		delay_2mSec
;	
;	Abstract:	This routine sits around and delays for
;					2.0 milliseconds.
;
;	Callable Routines:
		global	delay_2mSec
;
;	Called Routines:  None.
;
;	Global Variables Used:  None.
;
;	Local Variables Used:
;		b0_tmp1_lo contains count up counter byte 0
;
;	Return Values:
;
;		
;*****************************************************
;*****************************************************

delay_2mSec						;4.00MHz clock/4  = 1000ns/cpu cycle
	clrf	b0_tmp1_lo
d2ms_1
	goto	$+1					;2 cycles
	goto	$+1					;2 cycles
	nop							;1 cycle
	incfsz	b0_tmp1_lo,F		;1 cycle
	goto	d2ms_1				;2 cycles / => 256 loops x 8 cycles each = 2.048mSec
	return




;*****************************************************
;*****************************************************
;
;	Name:		delay_N50mSec
;	
;	Abstract:	This routine sits around and delays N*50mSec
;
;	Callable Routines:
		global	delay_N50mSec
;
;	Called Routines:  None.
;
;	Global Variables Used:
;		arg2_lo contains number of 50mSec delays to do
;
;	Local Variables Used:
;		b0_tmp1_lo contains count up counter byte 0
;		b0_tmp1_hi contains count down counter byte 1
;		b0_tmp2_lo contains count down counter for the number
;			of 50 millisecond intervals to delay
;
;	Return Values:
;
;		
;*****************************************************
;*****************************************************

delay_N50mSec					;Assumes a 4.00MHz clock/4  = 1000ns/cpu cycle
	movwf	w_temp				;Save W register for now

	movf	arg2_lo,W			;Number of 50mSec delays to do
	movwf	b0_tmp2_lo

	clrf	b0_tmp1_lo
d50ms_1
	movlw	0x31
	movwf	b0_tmp1_hi
d50ms_2
	nop							;1 cycle
	incfsz	b0_tmp1_lo,F		;1 cycle
	goto	d50ms_2				;2 cycles / => 256 loops * 4 cycles each = 1024uSec
	decfsz	b0_tmp1_hi,F		;1 cycle
	goto	d50ms_2				;2 cycles / => 48 loops * 1024uSec = 49.2mSec
	decfsz	b0_tmp2_lo,F		;1 cycle
	goto	d50ms_1				;2 cycles

	movf	w_temp,W			;Restore original W register value
	return


	end
;End of File (utilities.asm)
