;******************************************************
;******************************************************
;
; Main Project     : VFOpm
; Project Name     : VFOpm - Digital Variable Frequency Oscillator
; File Name        : variable_def.inc
; Version          : A01
; PIC Used         : PIC16F648A
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : Nov. 4, 2014
; Last Update date : Nov. 4, 2014
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
;
;******************************************************
;
;   Modification History:
;   =-=-=-=-=-=-=-=-=-=-=
;   20141104 pm - Initial creation.
;
;*****************************************************
; VARIABLE DEFINITIONS
;*****************************************************
; Shared Uninitialized Data Section

	cblock	0x70	      	; duplicated in all banks:
							;  0x070-0x07F, 0x0F0-0x0FF, 0x170-0x17F, 0x1F0-0x1FF

;	***** TOTAL LOCATIONS = 16, LOCATIONS USED = 13, LOCATIONS REMAINING =  3 *****

	w_temp					; variable used for context saving 
	status_temp				; variable used for context saving
	pclath_temp				; variable used for context saving

	arg1_wrd: 0, arg1_hi, arg1_lo	;variable used for passing arguments to called routines
	arg2_wrd: 0, arg2_hi, arg2_lo	;variable used for passing arguments to called routines
	arg3_wrd: 0, arg3_hi, arg3_lo	;variable used for passing arguments to called routines
	arg4_wrd: 0, arg4_hi, arg4_lo	;variable used for passing arguments to called routines
	arg5_wrd: 0, arg5_hi, arg5_lo	;variable used for passing arguments to called routines

	endc

;*****************************************************
; Uninitialized Data Section

	cblock	0x20

;	***** TOTAL LOCATIONS = 80, LOCATIONS USED = 66, LOCATIONS REMAINING = 14 *****


	b0_digit0		;Decimal Frequency
	b0_digit1
	b0_digit2
	b0_digit3
	b0_digit4
	b0_digit5
	b0_digit6
	b0_digit7

	b0_dds0			;Binary Frequency Bits
	b0_dds1
	b0_dds2
	b0_dds3

	b0_freq0		;Current Binary Frequency Bits
	b0_freq1
	b0_freq2
	b0_freq3

	b0_vfobase0		;Binary VF0 Base Frequency
	b0_vfobase1
	b0_vfobase2
	b0_vfobase3

	b0_opto_now		;Current read of the opto switch
	b0_opto_prev	;Previous read of the opto switch

	b0_mode_now		;Current read of the mode switch
	b0_mode_prev	;Previous read of the mode switch


	;LCD Message Space
	b0_mfreq: 0x0f	;15 locations for the freq message
	b0_mstep: 0x0f	;15 locations for the step message

	;Current Step Size
	b0_cstep		; 00000001=1hz,  00000010=10hz,  00000100=100hz
					; 00001000=1KHz, 00010000=10KHz, 00100000=100Khz
					; 01000000=1MHz, 10000000=10MHz

	b0_tmp1_wrd: 0, b0_tmp1_hi, b0_tmp1_lo
	b0_tmp2_wrd: 0, b0_tmp2_hi, b0_tmp2_lo
	b0_tmp3_wrd: 0, b0_tmp3_hi, b0_tmp3_lo
	b0_tmp4_wrd: 0, b0_tmp4_hi, b0_tmp4_lo
	b0_tmp5_wrd: 0, b0_tmp5_hi, b0_tmp5_lo
	b0_tmp_idx

	endc

;*****************************************************

	cblock	0xA0

;	***** TOTAL LOCATIONS = 80, LOCATIONS USED =  0, LOCATIONS REMAINING = 80 *****


	endc

;*****************************************************

	cblock	0x120

;	***** TOTAL LOCATIONS = 80, LOCATIONS USED = 0, LOCATIONS REMAINING = 80 *****


	endc

;*****************************************************

;End of File (variable_def.inc)