;******************************************************
;******************************************************
;
; Main Project     : VFO
; Project Name     : VFO - Digital Variable Frequency Oscillator
; File Name        : constants.inc
; Version          : A01
; PIC Used         : PIC16F648A
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : May 28, 2011
; Last Update date : May 28, 2011
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
;
;******************************************************
;
;	Modification History:
;	=-=-=-=-=-=-=-=-=-=-=
;	20110528 pm - Initial creation.
;
;***********************************************************************
;          == Conditional Compile Switches ===
;***********************************************************************
;
;
;***********************************************************************
; General definitions
#define	TRUE	0x01
#define	FALSE	0x00
#define	YES		0x01
#define	NO		0x00
#define	BANK0	0x00
#define	BANK1	0x80
#define	BANK2	0x100
#define	BANK3	0x180
;***********************************************************************
; System definitions
;
;***********************************************************************

; Zero VFO frequency in hex (this is for 5.00MHz)
;#define	t4		0x1f	;msb of custom vfo frequency
;#define	t3		0xff	;
;#define	t2		0xff	;
;#define	t1		0xfe	;lsb of custom vfo frequency (here it is 5.05MHz)

; Zero VFO frequeny in hex (this is for 5.05MHz)
;#define	t4		0x20	;msb of custom vfo frequency
;#define	t3		0x51	;
;#define	t2		0xeb	;
;#define	t1		0x85	;lsb of custom vfo frequency (here it is 5.05MHz)

; HARRIS DDS Commands via the DDS Latch:
;	Bit 7 = ~SEL_L/M	always high
;	Bit 6 = ~SFTEN		low when shifting in data
;	Bit 5 = ~MSB/LSB	always high
;	Bit 4 = ~LOAD		always high
;	Bit 3 = ~ENPHAC		low to generate output
;	Bit 2 = ~TXFR		pulse low to load a new frequency
;	Bit 1 = SD			data bit, high or low
;	Bit 0 = SCLK		clock "SD" in on rising edge

#define	dds_off	0xfc	;Output off Command to Harris DDS
#define	dds_on	0xf4	;Output on Command to Harris DDS
#define	xfer	0xf0	;Transfer Command to Harris DDS
#define	dat1	0xb6	;Data bit = 1 to Harris DDS
#define	dat0	0xb4	;Data bit = 0 to Harris DDS
#define	sclk_hi	0x01	;Clock bit is the 0 bit to Harris DDS
#define	sclk_lo	0xfe	;Clock bit is the 0 bit to Harris DDS
#define	lcnt	0x20	;Length of all Harris DDS commands (32 bits)

; Frequencies in Harris DDS talk.
#define	h1_4	0x00		;1hertz steps.
#define	h1_3	0x00
#define	h1_2	0x00
#define	h1_1	0x6c

#define	h10_4	0x00		;10hz.
#define	h10_3	0x00
#define	h10_2	0x04
#define	h10_1	0x32

#define	h100_4	0x00		;100hz.
#define	h100_3	0x00
#define	h100_2	0x29
#define	h100_1	0xf2

#define	k1_4	0x00		;1Khz.
#define	k1_3	0x01
#define	k1_2	0xa3
#define	k1_1	0x6f

#define	k10_4	0x00		;10Khz.
#define	k10_3	0x10
#define	k10_2	0x62
#define	k10_1	0x4e

#define	k100_4	0x00		;100Khz.
#define	k100_3	0xa3
#define	k100_2	0xd7
#define	k100_1	0x0b

#define	mhz_4	0x06		;1Mhz.
#define	mhz_3	0x66
#define	mhz_2	0x66
#define	mhz_1	0x67

#define	mhz10_4 0x40		;10 Mhz
#define	mhz10_3 0x00
#define	mhz10_2 0x00
#define	mhz10_1 0x00
;***********************************************************************

;***********************************************************************
; Special compile switches:

;***********************************************************************

;End of File (constants.inc)
