;******************************************************
;******************************************************
;
; Main Project     : VFO
; Project Name     : VFO - Digital Variable Frequency Oscillator
; File Name        : hardware.asm
; Version          : A01
; PIC Used         : PIC16F648A
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : May 28, 2011
; Last Update date : May 28, 2011
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
;
;******************************************************
;
;   Modification History:
;   =-=-=-=-=-=-=-=-=-=-=
;   20110528 pm - Initial creation.
;
;*****************************************************
;   === Include files ===
;*****************************************************
 	LIST   P=16F648A			;List directive to define processor

#include	P16F648A.INC		;Processor specific variable definitions
#include	constants.inc		;Coding constants
#include	micro_bits.inc		;Hardware defined bits
#include	variable_def.inc	;Variable definitions


HARDWARE_CODE	CODE				;hardware code space

;*****************************************************
;*****************************************************
;
;	Name:		init_hardware
;	
;	Abstract:
;	This is the cold start digital vfo hardware initialization
;	code. It is called by main as the first thing. The
;	presumption is that this code is executed whenever
;	the microcontroller is released from reset.
;
;	Callable Routines:
		global	init_hardware
;
;	Called Routines:  None.
;
;	Global Variables Used:  None.
;		
;	Local Variables Used:  None.
;	
;	Return Values:	None.
;		
;*****************************************************
;*****************************************************
init_hardware
	banksel	BANK0
	movlw	CFG_INTCON		;Turn off ALL of the various interrupts, should be done by
	movwf	INTCON			; reset, but just do it to be sure

	banksel	BANK1
	movlw	CFG_PIE1		;Turn off other individual interrupts, should be done by
	movwf	PIE1			; reset, but just do it to be sure

	banksel	BANK0
	movlw	CFG_PIR1		;Clear interrupt flags
	movwf	PIR1
	movlw	CFG_CMCON		;Turn off the PIC's A/D converters and make PortA be all digital I/O
	movwf	CMCON

	banksel	BANK1
	movlw	CFG_OPTION		;Disable Port B pullups
	movwf	OPTION_REG
	movlw	CFG_PCON		;Set Oscillator Frequency to 4MHz
	movwf	PCON

; Initialize the I/O pins
	banksel	BANK0
	movlw	CFG_PORTA		;Set the state of the pins
	movwf	PORTA
	movlw	CFG_PORTB
	movwf	PORTB

	banksel	BANK1
	movlw	CFG_TRISA		;Set the direction of the pins
	movwf	TRISA
	movlw	CFG_TRISB
	movwf	TRISB

	return



;*****************************************************
;*****************************************************
;
;	Name:		read_eeprom_location
;	
;	Abstract:	Read EEPROM location.
;
;	Callable Routines:
		global	read_eeprom_location
;
;	Called Routines:  None.
;		
;	Global Variables:
;		arg1_lo = address to read
;		
;	Local Variables:  None.
;	
;	Return Values:
;		arg1_hi = eedata read
;		
;*****************************************************
;*****************************************************
read_eeprom_location
	banksel	BANK1
	movf	arg1_lo,W		;Set the address to read
	movwf	EEADR
	movlw	0x00			;Clear the control register
	movwf	EECON1
	bsf		EECON1,RD		;Set the read bit to do the read
	nop
	movf	EEDATA,W		;Get the read data
	movwf	arg1_hi			;Put it into the return location
	return



;*****************************************************
;*****************************************************
;
;	Name:		write_eeprom_location
;	
;	Abstract:	Write EEPROM location.
;
;	Callable Routines:
		global	write_eeprom_location
;
;	Called Routines:  None.
;		
;	Global Variables:
;		arg1_lo = address to write
;		arg1_hi = data to write
;
;	Local Variables:  None.
;	
;	Return Values:	None.
;		
;*****************************************************
;*****************************************************
write_eeprom_location
	banksel	BANK1
	movf	arg1_lo,W		;Set the address to write
	movwf	EEADR
	movf	arg1_hi,W		;Set the data to write
	movwf	EEDATA
	bsf		EECON1,WREN		;Set the write enable bit to allow the write
;	bcf		INTCON,GIE		;Turn off interrupts for this
;	bcf		INTCON,GIE
;	NOW DO THE EXACT REQUIRED SEQUENCE to start the write operation
	movlw	0x55
	movwf	EECON2
	movlw	0xaa
	movwf	EECON2
	bsf		EECON1,WR
;	END OF EXACT REQUIRED SEQUENCE
;	bsf		INTCON,GIE		;Turn interrupts back on
write_eeprom_location_1
	btfsc	EECON1,WR		;Sit here and wait for the write to complete
	goto	write_eeprom_location_1
	bcf		EECON1,WREN		;Clear the write enable bit to disable the write mode
	return




	end
; End of File (hardware.asm)
