;**********************************************************************
;******************************************************
;******************************************************
;
; Main Project     : VFO
; Project Name     : VFO - Digital Variable Frequency Oscillator
; File Name        : variable_def.inc
; Version          : A01
; PIC Used         : PIC16F648A
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : May 28, 2011
; Last Update date : May 28, 2011
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
;
;******************************************************
;
;   Modification History:
;   =-=-=-=-=-=-=-=-=-=-=
;   20110528 pm - Initial creation.
;
;**********************************************************************
; VARIABLE DEFINITIONS
;*****************************************************
; Shared Uninitialized Data Section

	cblock	0x70	      	; duplicated in all banks:
							;  0x070-0x07F, 0x0F0-0x0FF, 0x170-0x17F, 0x1F0-0x1FF

;	***** TOTAL LOCATIONS = 16, LOCATIONS USED = 13, LOCATIONS REMAINING =  3 *****

	w_temp					; variable used for context saving 
	status_temp				; variable used for context saving
	pclath_temp				; variable used for context saving

	arg1_wrd: 0, arg1_hi, arg1_lo	;variable used for passing arguments to called routines
	arg2_wrd: 0, arg2_hi, arg2_lo	;variable used for passing arguments to called routines
	arg3_wrd: 0, arg3_hi, arg3_lo	;variable used for passing arguments to called routines
	arg4_wrd: 0, arg4_hi, arg4_lo	;variable used for passing arguments to called routines
	arg5_wrd: 0, arg5_hi, arg5_lo	;variable used for passing arguments to called routines

	endc

;*****************************************************
; Uninitialized Data Section

	cblock	0x20

	;Dummy register name to use when setting bank 0 access
	bank_0_gpr: 0

;	***** TOTAL LOCATIONS = 80, LOCATIONS USED = 67, LOCATIONS REMAINING = 13 *****


	b0_vfo4			;Always valid current VFO frequency
	b0_vfo3
	b0_vfo2
	b0_vfo1

	b0_step4		;Always valid current step frequency
	b0_step3
	b0_step2
	b0_step1

	b0_math4		;For math routines
	b0_math3
	b0_math2
	b0_math1

	b0_mathb4		;Math backup save
	b0_mathb3
	b0_mathb2
	b0_mathb1

	b0_scr4			;Some scratch locations
	b0_scr3
	b0_scr2
	b0_scr1

	b0_opto_now		;Current read of the opto switch
	b0_opto_prev	;Previous read of the opto switch

	b0_div32_ans	;Answer to 32 bit divide (done with many subtracts)
	b0_div32_borrow	;Borrow happened during 32 bit divide (done with many subtracts)

	b0_tempw		;Place to save w register


	;LCD Message Space
	b0_mfreq: 0x0f	;15 locations for the freq message
	b0_mstep: 0x0f	;15 locations for the step message

	;Current Step Size
	b0_cstep		; 0=1hz,  1=10hz,  2=100hz
					; 3=1KHz, 4=10KHz, 5=100Khz
					; 6=1MHz, 7=10MHz

	b0_tmp1_wrd: 0, b0_tmp1_hi, b0_tmp1_lo
	b0_tmp2_wrd: 0, b0_tmp2_hi, b0_tmp2_lo
	b0_tmp3_wrd: 0, b0_tmp3_hi, b0_tmp3_lo
	b0_tmp4_wrd: 0, b0_tmp4_hi, b0_tmp4_lo
	b0_tmp5_wrd: 0, b0_tmp5_hi, b0_tmp5_lo
	b0_tmp_idx

	endc

;*****************************************************

	cblock	0xA0

	;Dummy register name to use when setting bank 1 access
	bank_1_gpr: 0

;	***** TOTAL LOCATIONS = 80, LOCATIONS USED =  0, LOCATIONS REMAINING = 80 *****


	endc

;*****************************************************

	cblock	0x120

	;Dummy register name to use when setting bank 2 access
	bank_2_gpr: 0

;	***** TOTAL LOCATIONS = 80, LOCATIONS USED = 0, LOCATIONS REMAINING = 80 *****


	endc

;*****************************************************


;**********************************************************************

;End of File (variable_def.inc)