;******************************************************
;******************************************************
;
; Main Project     : FT301D
; Project Name     : FT301D - Replacement Digital Display
; File Name        : constants.inc
; Version          : A04
; PIC Used         : PIC16F887
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : May 1, 2011
; Last Update date : Sep 5, 2013
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
;
;******************************************************
;
;	Modification History:
;	=-=-=-=-=-=-=-=-=-=-=
;	20110501 pm - Initial creation.
;	20130829 pm - Added display mode and brightness level control
;	20130830 pm - Added user programmable display mode and brightness level
;
;***********************************************************************
;          == Conditional Compile Switches ===
;***********************************************************************
; Display Mode Value EEPROM Address
#define	DISPLAY_MODE_ADDR	0x00

; Display Mode Value
#define	TEN_HERTZ_MODE		0x00	;display "-.xxx.xx" for low bands
									;display "-.xxx.xx" for high bands

#define	HUNDRED_HERTZ_MODE	0x01	;display " x.xxx.x" for low bands
									;display "xx.xxx.x" for high bands

#define	FLOAT_HERTZ_MODE	0x02	;display "x.xxx.xx" for low bands
									;display "xx.xxx.x" for high bands

; LED Brightness Value EEPROM Address
#define	BRIGHTNESS_ADDR		0x01

; LED Brightness Level
; Range is from 0x00 [dim] to 0xff [bright]
; Note: Visual brightness curve is logrithmic
#define	BRIGHTNESS_LEVEL_1	0x04
#define	BRIGHTNESS_LEVEL_2	0x1f
#define	BRIGHTNESS_LEVEL_3	0x3f
#define	BRIGHTNESS_LEVEL_4	0x7f
#define	BRIGHTNESS_LEVEL_5	0xff
;
;***********************************************************************
; General definitions
#define	TRUE	0x01
#define	FALSE	0x00
#define	YES		0x01
#define	NO		0x00
#define	BANK0	0x00
#define	BANK1	0x80
#define	BANK2	0x100
#define	BANK3	0x180
;***********************************************************************
; System definitions
;
;***********************************************************************
; LED Digit Drive (active low):
#define	HUNDREDS_OF_HZ	0xfe	;in PORTE
#define ONES_OF_KHZ		0xfd	;in PORTE
#define TENS_OF_KHZ		0xfb	;in PORTE
#define	HUNDREDS_OF_KHZ	0xfd	;in PORTC
#define	ONES_OF_MHZ		0xfb	;in PORTC
#define	TENS_OF_MHZ		0xf7	;in PORTC

; LED Segment constants:
#define A_SEG	0x40	;in PORTB
#define B_SEG	0x01	;in PORTA
#define C_SEG	0x04	;in PORTA
#define	D_SEG	0x20	;in PORTA
#define	E_SEG	0x08	;in PORTA
#define	F_SEG	0x80	;in PORTB
#define	G_SEG	0x02	;in PORTA
#define	DP_SEG	0x10	;in PORTA

#define	BLANK	0x00

#define	PORTA_SEGMENT_MASK	B'00111111'
#define	PORTB_SEGMENT_MASK	B'11000000'

;
;     a
;   -----
; f|     |b
;  |  g  |
;   -----
; e|     |c
;  |  d  |
;   -----
;          dp

#define	CHAR_SP          BLANK                                                  ;
#define	CHAR_BANG                                D_SEG         | F_SEG          ;
#define	CHAR_QUOTE               B_SEG                         | F_SEG          ;
#define	CHAR_POUND       A_SEG | B_SEG                         | F_SEG | G_SEG  ;raised o
#define	CHAR_DOLLAR      BLANK                                                  ;
#define	CHAR_PERCENT     BLANK                                                  ;
#define	CHAR_AMPERSAND   BLANK                                                  ;
#define	CHAR_SQUOTE              B_SEG                                          ;
#define	CHAR_LPAREN      A_SEG                 | D_SEG | E_SEG | F_SEG          ;[
#define	CHAR_RPAREN      A_SEG | B_SEG | C_SEG | D_SEG                          ;]
#define	CHAR_SPLAT       BLANK                                                  ;
#define	CHAR_PLUS        BLANK                                                  ;
#define	CHAR_COMMA       BLANK                                                  ;
#define	CHAR_MINUS                                                       G_SEG  ;
#define	CHAR_PERIOD      BLANK                                                  ;
#define	CHAR_SLASH               B_SEG                 | E_SEG         | G_SEG  ;
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
#define CHAR_0           A_SEG | B_SEG | C_SEG | D_SEG | E_SEG | F_SEG          ;0
#define CHAR_1                   B_SEG | C_SEG                                  ;1
#define CHAR_2           A_SEG | B_SEG         | D_SEG | E_SEG         | G_SEG  ;2
#define CHAR_3           A_SEG | B_SEG | C_SEG | D_SEG                 | G_SEG  ;3
#define CHAR_4                   B_SEG | C_SEG                 | F_SEG | G_SEG  ;4
#define CHAR_5           A_SEG         | C_SEG | D_SEG         | F_SEG | G_SEG  ;5
#define CHAR_6           A_SEG         | C_SEG | D_SEG | E_SEG | F_SEG | G_SEG  ;6
#define CHAR_7           A_SEG | B_SEG | C_SEG                                  ;7
#define CHAR_8           A_SEG | B_SEG | C_SEG | D_SEG | E_SEG | F_SEG | G_SEG  ;8
#define CHAR_9           A_SEG | B_SEG | C_SEG                 | F_SEG | G_SEG  ;9
#define CHAR_CO          A_SEG                 | D_SEG                          ;colon - top and bottom bars
#define CHAR_SC                  B_SEG         | D_SEG                          ;semicolon
#define CHAR_LT                                  D_SEG | E_SEG                  ;less than
#define CHAR_EQ                                  D_SEG                 | G_SEG  ;equal - lower two bars
#define CHAR_GT                          C_SEG | D_SEG                          ;greater than
#define CHAR_QM          A_SEG | B_SEG | C_SEG                 | F_SEG          ;question mark

#define CHAR_AT          A_SEG | B_SEG         | D_SEG | E_SEG | F_SEG | G_SEG  ;@
#define CHAR_A           A_SEG | B_SEG | C_SEG         | E_SEG | F_SEG | G_SEG  ;A
#define CHAR_B                           C_SEG | D_SEG | E_SEG | F_SEG | G_SEG  ;lower case b
#define CHAR_C           A_SEG                 | D_SEG | E_SEG | F_SEG          ;C
#define CHAR_D                   B_SEG | C_SEG | D_SEG | E_SEG         | G_SEG  ;lower case d
#define CHAR_E           A_SEG                 | D_SEG | E_SEG | F_SEG | G_SEG  ;E
#define CHAR_F           A_SEG                         | E_SEG | F_SEG | G_SEG  ;F
#define CHAR_G           A_SEG | B_SEG | C_SEG | D_SEG         | F_SEG | G_SEG  ;lower case g
#define CHAR_H                   B_SEG | C_SEG         | E_SEG | F_SEG | G_SEG  ;H
#define CHAR_I                   B_SEG | C_SEG                                  ;I - right side
#define CHAR_J                   B_SEG | C_SEG | D_SEG | E_SEG                  ;J
#define CHAR_K                                           E_SEG | F_SEG | G_SEG  ;sort of |-
#define CHAR_L                                   D_SEG | E_SEG | F_SEG          ;L
#define CHAR_M           A_SEG | B_SEG | C_SEG         | E_SEG | F_SEG          ;tall n
#define CHAR_N                           C_SEG         | E_SEG         | G_SEG  ;lower case n
#define CHAR_O           A_SEG | B_SEG | C_SEG | D_SEG | E_SEG | F_SEG          ;O

#define CHAR_P           A_SEG | B_SEG                 | E_SEG | F_SEG | G_SEG  ;P
#define CHAR_Q           A_SEG | B_SEG | C_SEG                 | F_SEG | G_SEG  ;same as 9
#define CHAR_R                                           E_SEG         | G_SEG  ;lower case r
#define CHAR_S           A_SEG         | C_SEG | D_SEG         | F_SEG | G_SEG  ;same as 5
#define CHAR_T                                   D_SEG | E_SEG | F_SEG | G_SEG  ;sort of t
#define CHAR_U                   B_SEG | C_SEG | D_SEG | E_SEG | F_SEG          ;U
#define CHAR_V                   B_SEG | C_SEG | D_SEG | E_SEG | F_SEG          ;same as U
#define CHAR_W                   B_SEG | C_SEG | D_SEG | E_SEG | F_SEG          ;same as U
#define CHAR_X                   B_SEG | C_SEG         | E_SEG | F_SEG | G_SEG  ;same as H
#define CHAR_Y                   B_SEG | C_SEG | D_SEG         | F_SEG | G_SEG  ;Y
#define CHAR_Z           A_SEG | B_SEG         | D_SEG | E_SEG         | G_SEG  ;same as 2
#define CHAR_LB          A_SEG                 | D_SEG | E_SEG | F_SEG			;left bracket
#define CHAR_BS                          C_SEG                 | F_SEG | G_SEG  ;back slash
#define CHAR_RB          A_SEG | B_SEG | C_SEG | D_SEG                          ;right bracket
#define CHAR_TD          A_SEG                                                  ;tilda - top segment
#define CHAR_UL                                  D_SEG                          ;underline - lower segment
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
; Possible Substitution Characters
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
#define CHAR_11                  B_SEG | C_SEG         | E_SEG | F_SEG          ;
#define CHAR_HE          A_SEG                                         | G_SEG  ;high equal
#define CHAR_LH                          C_SEG         | E_SEG | F_SEG | G_SEG  ;lower case h
#define CHAR_LI                          C_SEG                                  ;lower case i
#define CHAR_LO                          C_SEG | D_SEG | E_SEG         | G_SEG  ;lower case o
#define CHAR_LU                          C_SEG | D_SEG | E_SEG                  ;lower case u
#define	CHAR_TB          A_SEG                 | D_SEG                 | G_SEG	;tripple bar
#define CHAR_R7          A_SEG                         | E_SEG | F_SEG          ;reversed 7
;plus many more are possible...
;***********************************************************************

;End of File (constants.inc)
