;***********************************************************************
;***********************************************************************
;
; Main Project     : FT301D
; Project Name     : FT301D - Replacement Digital Display
; File Name        : micro_bits.inc
; Version          : A03
; PIC Used         : PIC16F887
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : May 1, 2011
; Last Update date : May 1, 2011
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
;
;**********************************************************************
;
;	Modification History:
;	=-=-=-=-=-=-=-=-=-=-=
;	20110501 pm - Initial creation.
;	
;***********************************************************************
;***********************************************************************

;Register Configurations
;
;***********************************************************************
;	=== I/O REGISTERS ===
;***********************************************************************
#define	CFG_PORTA	0x00		;Addr 0x05	
;												:7: low  <Not Used>
;												:6: low  <Not Used>
;												:5: low  <D_SEG off>
;												:4: low  <DP_SEG off>
;												:3: low  <E_SEG off>
;												:2: low  <C_SEG off>
;												:1: low  <G_SEG off>
;												:0: low  <B_SEG off>
;***********************************************************************
#define	CFG_TRISA	0x80		;Addr 0x85
;												:7: input   <optional clock input>
;												:6: output  <Not Used>
;												:5: output  <D_SEG>
;												:4: output  <DP_SEG>
;												:3: output  <E_SEG>
;												:2: output  <C_SEG>
;												:1: output  <G_SEG>
;												:0: output  <B_SEG>
;***********************************************************************
#define	CFG_PORTB	0x00		;Addr 0x06	
;												:7: low  <ICSPDAT, Programming Data>
;												:6: low  <ICSPCLK, Programming Clock>
;												:5: low  <T1G~, Timer 1 Gate>
;												:4: low  <Not Used>
;												:3: low  <PGM, Programming Mode Select>
;												:2: low  <Not Used>
;												:1: low  <Not Used>
;												:0: low  <Not Used>
;***********************************************************************
#define	CFG_TRISB	0x20		;Addr 0x86
;												:7: output  <ICSPDAT, Programming Data>
;												:6: output  <ICSPCLK, Programming Clock>
;												:5: input   <T1G~, Timer 1 Gate>
;												:4: output  <Not Used>
;												:3: output  <PGM, Programming Mode Select>
;												:2: output  <Not Used>
;												:1: output  <Not Used>
;												:0: output  <Not Used>
;***********************************************************************
#define	CFG_PORTC	0x00		;Addr 0x07	
;												:7: low  <ONES_MHZ_A>
;												:6: low  <Not Used>
;												:5: low  <Not Used>
;												:4: low  <Not Used>
;												:3: high <TENS_MHZ~>
;												:2: high <ONES_MHZ~>
;												:1: high <HUNS_KHZ~>
;												:0: high <T1CKI, Timer 1 Clock Input (Freq)>
;***********************************************************************
#define	CFG_TRISC	0x81		;Addr 0x87
;												:7: input   <ONES_MHZ_A>
;												:6: output  <Not Used>
;												:5: output  <Not Used>
;												:4: output  <Not Used>
;												:3: output  <TENS_MHZ~>
;												:2: output  <ONES_MHZ~>
;												:1: output  <HUNS_KHZ~>
;												:0: input   <T1CKI, Timer 1 Clock Input (Freq)>
;***********************************************************************
#define	CFG_PORTD	0x00		;Addr 0x08	
;												:7: low  <WWV_5MHZ~>
;												:6: low  <ADD_500KHZ~>
;												:5: low  <BLANK_1MHZ~>
;												:4: low  <ONES_MHZ_B>
;												:3: low  <ONES_MHZ_C>
;												:2: low  <ONES_MHZ_D>
;												:1: low  <MSD_1~>
;												:0: low  <MSD_2~>
;***********************************************************************
#define	CFG_TRISD	0xFF		;Addr 0x88
;												:7: input   <WWV_5MHZ~>
;												:6: input   <ADD_500KHZ~>
;												:5: input   <BLANK_1MHZ~>
;												:4: input   <ONES_MHZ_B>
;												:3: input   <ONES_MHZ_C>
;												:2: input   <ONES_MHZ_D>
;												:1: input   <MSD_1~>
;												:0: input   <MSD_2~>
;***********************************************************************
#define	CFG_PORTE	0x00		;Addr 0x09	
;												:7: low  <Not Used>
;												:6: low  <Not Used>
;												:5: low  <Not Used>
;												:4: low  <Not Used>
;												:3: low  <~MCLR>
;												:2: low  <TENS_KHZ~>
;												:1: low  <ONES_KHZ~>
;												:0: low  <HUNS_HZ~>
;***********************************************************************
#define	CFG_TRISE	0x08		;Addr 0x89
;												:7: output  <Not Used>
;												:6: output  <Not Used>
;												:5: output  <Not Used>
;												:4: output  <Not Used>
;												:3: input   <~MCLR>
;												:2: output  <TENS_KHZ~>
;												:1: output  <ONES_KHZ~>
;												:0: output  <HUNS_HZ~>
;***********************************************************************
#define	CFG_INTCON	0xC0		;Addr 0x0B
;												:7: <GIE - Enable ALL Interrupts>
;												:6: <PEIE - Enable Peripheral Interrupts>
;												:5: <T0IE - Disable TMR0 Overflow Interrupt>
;												:4: <INTE - Disable External INT>
;												:3: <RBIE - Disable RB Change Interrupt>
;												:2: <T0IF - TMR0 Overflow Flag>
;												:1: <INTF - External INT Flag>
;												:0: <RBIF - Port B Change Flag>
;***********************************************************************
#define	CFG_T1CON	0xC7		;Addr 0x10
;												:7: <T1GINV  - Timer 1 Counts When Gate is High>
;												:6: <TMR1GE  - Timer 1 Gate Enable, count when gate on>
;												:5: <T1CKPS1 - Timer 1 Prescaler, 1:1>
;												:4: <T1CKPS0 - Timer 1 Prescaler, 1:1>
;												:3: <T1OSCEN - LP Oscillator Enable, off>
;												:2: </T1SYNC - Timer 1 Ext Clock Sync, off>
;												:1: <TMR1CS  - Timer 1 Clock Source, External>
;												:0: <TMR1ON  - Turn on Timer 1, on>
;***********************************************************************
#define	CFG_OPTION	0x80		;Addr 0x81
;												:7: <PORT B Pull-ups Disable>
;												:6: <INTEDG, Not Used, Falling Edge>
;												:5: <TMR0 clock source, Not Used, - internal clk>
;												:4: <TMR0 source edge, Not Used - rising>
;												:3: <PSA, Not Used - prescaler assigned to Timer0>
;												:2: <PRESCALER, Not Used = 1:2>
;												:1: <PRESCALER, Not Used = 1:2>
;												:0: <PRESCALER, Not Used = 1:2>
;***********************************************************************
#define	CFG_CM2CON1	0x02		;Addr 0x109
;												:7: <MC1OUT, Not Used>
;												:6: <MC2OUT, Not Used>
;												:5: <C1RSEL, Not Used>
;												:4: <C2RSEL, Not Used>
;												:3: <NA>
;												:2: <NA>
;												:1: <T1GSS, Timer 1 Gate Source Select - /T1G>
;												:0: <C2SYNC, Not Used>
;***********************************************************************
#define	CFG_T2CON	0x07		;Addr 0x12
;												:7: <NA>
;												:6: <TOUTPS3 - Timer 2 PostScaler = 0; 1:1>
;												:5: <TOUTPS2 - Timer 2 PostScaler = 0; 1:1>
;												:4: <TOUTPS1 - Timer 2 PostScaler = 0; 1:1>
;												:3: <TOUTPS0 - Timer 2 PostScaler = 0; 1:1>
;												:2: <TMR2ON  - Timer 2 On>
;												:1: <T2CKPS1 - Timer 2 Prescaler = 1; 16>
;												:0: <T2CKPS0 - Timer 2 PreScaler = 1; 16>
;***********************************************************************
#define	CFG_ANSELH	0xDF		;Addr 0x189
;												:7: <NA>
;												:6: <NA>
;												:5: <ANS13 - Analog Select RB5 Pin>
;												:4: <ANS12 - Analog Select RB0 Pin>
;												:3: <ANS11 - Analog Select RB4 Pin>
;												:2: <ANS10 - Analog Select RB1 Pin>
;												:1: <ANS9  - Analog Select RB3 Pin>
;												:0: <ANS8  - Analog Select RB2 Pin>
;***********************************************************************
;End of File (micro_bits.inc)
