;**********************************************************************
;******************************************************
;******************************************************
;
; Main Project     : FT301D
; Project Name     : FT301D - Replacement Digital Display
; File Name        : variable_def.inc
; Version          : A03
; PIC Used         : PIC16F887
; Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
; Initial Date     : May 1, 2011
; Last Update date : May 1, 2011
; Firmware Eng.    : WA7ZVY
; HW Design Eng.   : WA7ZVY
;
;******************************************************
;
;   Modification History:
;   =-=-=-=-=-=-=-=-=-=-=
;   20110501 pm - Initial creation.
;
;**********************************************************************
; VARIABLE DEFINITIONS
;*****************************************************
; Shared Uninitialized Data Section

	cblock	0x70	      	; duplicated in all banks:
							;  0x070-0x07F, 0x0F0-0x0FF, 0x170-0x17F, 0x1F0-0x1FF

;	***** TOTAL LOCATIONS = 16, LOCATIONS USED = 13, LOCATIONS REMAINING =  3 *****

	w_temp					; variable used for context saving 
	status_temp				; variable used for context saving
	pclath_temp				; variable used for context saving

	arg1_wrd: 0, arg1_hi, arg1_lo	;variable used for passing arguments to called routines
	arg2_wrd: 0, arg2_hi, arg2_lo	;variable used for passing arguments to called routines
	arg3_wrd: 0, arg3_hi, arg3_lo	;variable used for passing arguments to called routines
	arg4_wrd: 0, arg4_hi, arg4_lo	;variable used for passing arguments to called routines
	arg5_wrd: 0, arg5_hi, arg5_lo	;variable used for passing arguments to called routines

	endc

;*****************************************************
; Uninitialized Data Section

	cblock	0x20

	;Dummy register name to use when setting bank 0 access
	bank_0_gpr: 0

;	***** TOTAL LOCATIONS = 80, LOCATIONS USED = 32, LOCATIONS REMAINING = 48 *****

	;Frequency counter registers (13 MHz = 0xc65d40, 13.5 MHz = 0xcdfe60)
	b0_counter0		;b0_counter0 is a copy of the TMR1L value
	b0_counter1		;b0_counter1 is a copy of the TMR1H value
	b0_counter2		;this is the start of the extended count past TMR1H
	b0_counter3		;this is the extension past b0_counter2 (should always be zero!)

	;Digit select counter to determine which digit to display
	b0_digit_select

	;Flag bits for individual decimal point activation (00000000 to 00111111)
	b0_dpoint_flags

	;Digit memory (stored as ASCII values)
	b0_digit0		;Hundreds of hertz
	b0_digit1		;Kilohertz
	b0_digit2		;Tens of kilohertz
	b0_digit3		;Hundreds of kilohertz
	b0_digit4		;Megahertz
	b0_digit5		;Tens of megahertz

	;LED Segment memory (contain the actual bits to light up appropriate segments)
	b0_digit0_segments
	b0_digit1_segments
	b0_digit2_segments
	b0_digit3_segments
	b0_digit4_segments
	b0_digit5_segments

	b0_underflow	;Frequency Counter has underflowed
	b0_overflow		;Frequency Counter has overflowed
	b0_error_flags	;Frequency Counter did something screwy

	b0_tmp1_wrd: 0, b0_tmp1_hi, b0_tmp1_lo
	b0_tmp2_wrd: 0, b0_tmp2_hi, b0_tmp2_lo
	b0_tmp3_wrd: 0, b0_tmp3_hi, b0_tmp3_lo
	b0_tmp4_wrd: 0, b0_tmp4_hi, b0_tmp4_lo
	b0_tmp5_wrd: 0, b0_tmp5_hi, b0_tmp5_lo
	b0_tmp_idx

	endc

;*****************************************************

	cblock	0xA0

	;Dummy register name to use when setting bank 1 access
	bank_1_gpr: 0

;	***** TOTAL LOCATIONS = 80, LOCATIONS USED = 10, LOCATIONS REMAINING = 70 *****

;	Some temporary registers for bank 1
	b1_tmp1_wrd: 0, b1_tmp1_hi, b1_tmp1_lo
	b1_tmp2_wrd: 0, b1_tmp2_hi, b1_tmp2_lo
	b1_tmp3_wrd: 0, b1_tmp3_hi, b1_tmp3_lo
	b1_tmp4_wrd: 0, b1_tmp4_hi, b1_tmp4_lo
	b1_tmp5_wrd: 0, b1_tmp5_hi, b1_tmp5_lo

	endc

;*****************************************************

	cblock	0x110

	;Dummy register name to use when setting bank 2 access
	bank_2_gpr: 0

;	***** TOTAL LOCATIONS = 96, LOCATIONS USED = 10, LOCATIONS REMAINING = 86 *****

;	Some temporary registers for bank 2
	b2_tmp1_wrd: 0, b2_tmp1_hi, b2_tmp1_lo
	b2_tmp2_wrd: 0, b2_tmp2_hi, b2_tmp2_lo
	b2_tmp3_wrd: 0, b2_tmp3_hi, b2_tmp3_lo
	b2_tmp4_wrd: 0, b2_tmp4_hi, b2_tmp4_lo
	b2_tmp5_wrd: 0, b2_tmp5_hi, b2_tmp5_lo

	endc

;*****************************************************

	cblock	0x190

	;Dummy register name to use when setting bank 3 access
	bank_3_gpr: 0

;	***** TOTAL LOCATIONS = 96, LOCATIONS USED = 10, LOCATIONS REMAINING =  86 *****


;	Some temporary registers for bank3
	b3_tmp1_wrd:0, b3_tmp1_hi, b3_tmp1_lo
	b3_tmp2_wrd:0, b3_tmp2_hi, b3_tmp2_lo
	b3_tmp3_wrd:0, b3_tmp3_hi, b3_tmp3_lo
	b3_tmp4_wrd:0, b3_tmp4_hi, b3_tmp4_lo
	b3_tmp5_wrd:0, b3_tmp5_hi, b3_tmp5_lo

	endc
;*****************************************************



;**********************************************************************

;End of File (variable_def.inc)