// ******************************************************
// ******************************************************
// 
//  Main Project     : OCRG
//  Project Name     : OCRG WDPC - WatchDog Power Cycler
//  File Name        : comm.c 
//  Version          : x0.1
//  PIC Used         : PIC16F648A
//  Compiler         : C2C plus C-Compiler
//  Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
//  Initial Date     : Aug 28, 2008
//  Last Update date : Aug 28, 2008 0.1
//  Tab size         : 3
//  Firmware Eng.    : WA7ZVY
//  HW Design Eng.   : WA7ZVY
// 
// ******************************************************
// 
//  Description of this C code:
// 
//  This routine sends morse code characters out the WATCHDOG_ALIVE LED. 
// 
// ******************************************************
// 
// 	Function List (in top-2-bottom order):
//			send_morse_element(char element)
//
// ******************************************************
// 
// 	Modification History:
// 	=-=-=-=-=-=-=-=-=-=-=
// 	08-28-08 pm - Initial creation.
// 	
// ******************************************************
// ******************************************************

// *****************************************************
//    === Include files ===
// *****************************************************
#include	"p16f648a.h";
#include	"constants.h";
#include	"micro_bits.h";
#include	"main.h";
#include	"init_hardware.h"
//#include	"comm.h"



// *****************************************************
// 	=== Global Variables ===
// *****************************************************

// Variables to send morse code string
//	char	element;


// *****************************************************
// 	=== Local Variables ===
// *****************************************************

// Variable for delay for time
//	char	time;


// *****************************************************
// *****************************************************
//
// 	Name:		delay_for
// 	
// 	Abstract:	Delays for a morse amount of time.
// 		
// 	Global Variables:
// 		
// 	Local Variables:
// 	
//		int i;
//
// 	Return Values:	None.
// 		
// *****************************************************
// *****************************************************
void delay_for(char time)
{
	int i;
	
	while(time > 0x00)
	{
		for(i = 0x0000; i != MORSE_SPEED; i++)
		{
			asm nop;
		}
		time--;	
	}
}



// *****************************************************
// *****************************************************
//
// 	Name:		TimeDelay
// 	
// 	Abstract:
// 		This routine delays a number of seconds (0 to 255)
// 		
// 	Global Variables:
// 		
// 	Local Variables:
// 	
// 	Return Values:	None.
// 		
// *****************************************************
// *****************************************************
void TimeDelay(char seconds)
{
	disable_interrupt(GIE);
	disable_interrupt(GIE);
	count50msec = 0x00;
	count1sec = 0x00;
	enable_interrupt(GIE);
	
	while(seconds != count1sec)
		asm nop;
	return;
}



// *****************************************************
// *****************************************************
//
// 	Name:		send_morse_element
// 	
// 	Abstract:	Sends out a morse dash, dot, or space.
// 		
// 	Global Variables:
// 		
// 	Local Variables:
// 	
// 	Return Values:	None.
// 		
// *****************************************************
// *****************************************************
void send_morse_element(char element)
{
	if(element == '-')			// morse dash
	{
		clear_bit(porta, PENDING_DOOM_LED);			// turn on LEDs for a dash time
		asm nop;
		clear_bit(porta, AC_POWER_OFF_LED);
		asm nop;
		clear_bit(porta, AC_POWER_ON_LED);
		asm nop;
		clear_bit(porta, BOOT_WAIT_LED);
		asm nop;
		clear_bit(porta, WATCHDOG_ARMED_LED);
		asm nop;
		clear_bit(porta, WATCHDOG_ALIVE_LED);
		asm nop;
		delay_for(0x03);
		set_bit(porta, PENDING_DOOM_LED);			// turn off LEDs
		asm nop;
		set_bit(porta, AC_POWER_OFF_LED);
		asm nop;
		set_bit(porta, AC_POWER_ON_LED);
		asm nop;
		set_bit(porta, BOOT_WAIT_LED);
		asm nop;
		set_bit(porta, WATCHDOG_ARMED_LED);
		asm nop;
		set_bit(porta, WATCHDOG_ALIVE_LED);
		asm nop;
		delay_for(0x01);
	}
	if(element == '.')			// morse dot
	{
		clear_bit(porta, PENDING_DOOM_LED);			// turn on LEDs for a dot time
		asm nop;
		clear_bit(porta, AC_POWER_OFF_LED);
		asm nop;
		clear_bit(porta, AC_POWER_ON_LED);
		asm nop;
		clear_bit(porta, BOOT_WAIT_LED);
		asm nop;
		clear_bit(porta, WATCHDOG_ARMED_LED);
		asm nop;
		clear_bit(porta, WATCHDOG_ALIVE_LED);
		asm nop;
		delay_for(0x01);
		set_bit(porta, PENDING_DOOM_LED);			// turn off LEDs
		asm nop;
		set_bit(porta, AC_POWER_OFF_LED);
		asm nop;
		set_bit(porta, AC_POWER_ON_LED);
		asm nop;
		set_bit(porta, BOOT_WAIT_LED);
		asm nop;
		set_bit(porta, WATCHDOG_ARMED_LED);
		asm nop;
		set_bit(porta, WATCHDOG_ALIVE_LED);
		asm nop;
		delay_for(0x01);
	}
	if(element == ' ')			// character space
	{
		set_bit(porta, PENDING_DOOM_LED);			// turn off LEDs for a space time
		asm nop;
		set_bit(porta, AC_POWER_OFF_LED);
		asm nop;
		set_bit(porta, AC_POWER_ON_LED);
		asm nop;
		set_bit(porta, BOOT_WAIT_LED);
		asm nop;
		set_bit(porta, WATCHDOG_ARMED_LED);
		asm nop;
		set_bit(porta, WATCHDOG_ALIVE_LED);
		asm nop;
		delay_for(0x03);
		set_bit(porta, PENDING_DOOM_LED);			// turn off LEDs
		asm nop;
		set_bit(porta, AC_POWER_OFF_LED);
		asm nop;
		set_bit(porta, AC_POWER_ON_LED);
		asm nop;
		set_bit(porta, BOOT_WAIT_LED);
		asm nop;
		set_bit(porta, WATCHDOG_ARMED_LED);
		asm nop;
		set_bit(porta, WATCHDOG_ALIVE_LED);
		asm nop;
		delay_for(0x01);
	}
}


// End of File (comm.c)
