// ******************************************************
// ******************************************************
// 
//  Main Project     : OCRG
//  Project Name     : OCRG WDPC - WatchDog Power Cycler
//  File Name        : constants.h 
//  Version          : x0.1
//  PIC Used         : PIC16F648A
//  Compiler         : C2C plus C-Compiler
//  Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
//  Initial Date     : Aug 28, 2008
//  Last Update date : Aug 28, 2008 0.1
//  Tab size         : 3
//  Firmware Eng.    : WA7ZVY
//  HW Design Eng.   : WA7ZVY
// 
// ******************************************************
// 
// 	Modification History:
// 	=-=-=-=-=-=-=-=-=-=-=
// 	08-28-08 pm - Initial creation.
//

// ***********************************************************************
//           == Conditional Compile Switches ===
// ***********************************************************************
//
//
// ***********************************************************************

// General definitions
#define	TRUE	0x0001
#define	FALSE	0x0000
#define	YES		0x0001
#define	NO		0x0000

#define TICKTIMELO1	0x00B0
#define	TICKTIMEHI1	0x003C

#define	DOOMCOUNT	0x0028			// 2 seconds worth of 50 millisecond ticks
#define	DEADCOUNT	0x0050			// 4 seconds worth of 50 millisecond ticks
#define	PENDING_DOOM_DELAY	0x0001	// Wait 1 second before starting the power cycle sequence
#define	POWER_OFF_DELAY	0x0005		// Turn the power off for 5 seconds when rebooting
#define	AC_POWER_ON_DELAY	0x0002	// Wait 2 seconds for power to re-establish itself
#define	BOOT_WAIT_DELAY	0x003C		// Wait 60 seconds for the PC to reboot and get running
#define	BLINKRATE	0x0400			// Blinkrate for the WatchDog Alive LED

#define	MORSE_SPEED	0x2800			// Morse code speed for light blink at power up

// End of File (constants.h)
