// ******************************************************
// ******************************************************
// 
//  Main Project     : OCRG
//  Project Name     : OCRG WDPC - WatchDog Power Cycler
//  File Name        : init_hardware.c 
//  Version          : x0.1
//  PIC Used         : PIC16F648A
//  Compiler         : C2C plus C-Compiler
//  Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
//  Initial Date     : Aug 28, 2008
//  Last Update date : Aug 28, 2008 0.1
//  Tab size         : 3
//  Firmware Eng.    : WA7ZVY
//  HW Design Eng.   : WA7ZVY
// 
// ******************************************************
// 
//  Description of this C code:
// 
//  This code initializes the WDPC hardware to an
//  operational state. The following devices are initialized
//  by this code:
//		1). PIC16F648A Micro-Controller I/O Ports
//
//	This routine is called by main at the release
//	of power on reset. 
// 
// ******************************************************
//
//		Function List (in top-2-bottom order):
//		void init_hardware(void);
//
// ******************************************************
// 
// 	Modification History:
// 	=-=-=-=-=-=-=-=-=-=-=
//		08-28-08 pm - Initial creation
// 	
// ******************************************************
// ******************************************************


// *****************************************************
// 	=== Include files ===
// *****************************************************
#include	"p16f648a.h";
#include	"constants.h";
#include	"micro_bits.h";
#include	"main.h";
//#include	"init_hardware.h"
#include	"comm.h"



// *****************************************************
// 	=== Compiler Conditional Compile Switches ===
// *****************************************************


// *****************************************************
// 	=== Global Variables ===
// *****************************************************


// *****************************************************
// 	=== Local Variables ===
// *****************************************************


// *****************************************************
// *****************************************************
//
// 	Name:		init_hardware
// 	
// 	Abstract:
//		This is the cold start WDPC hardware initialization
//		code. It is called by main as the first thing. The
//		presumption is that this code is executed whenever
//		the WDPC microcontroller is released from reset.
// 		
// 	Global Variables:
// 		
// 	Local Variables:
// 	
// 	Return Values:	None.
// 		
// *****************************************************
// *****************************************************
void init_hardware(void)
{
	//Turn off ALL of the various interrupts, should be done by a reset, but just do it to be sure
	intcon = 0x00;
	pie1 = 0x00;
	
	//Turn off the PIC's A/D converters and make PortA be all digital I/O
	cmcon = CFG_CMCON;
	
	// Set option register -- do the exact required sequence to set the option register
	asm clrwdt;
	option_reg	=	CFG_OPTION;		// Turn off the PORTB pullups, set prescaler value for timer 0
	
	// Setup PORTA
	porta  = CFG_PORTA;
	trisa  = CFG_TRISA;
	
	// Setup PORTB
	portb  = CFG_PORTB;
	trisb  = CFG_TRISB;
}

// End of File (init_hardware.c)
