// ***********************************************************************
// ***********************************************************************
// 
//  Main Project     : OCRG
//  Project Name     : OCRG WDPC - WatchDog Power Cycler
//  File Name        : micro_bits.h 
//  Version          : x0.1
//  PIC Used         : PIC16F648A
//  Compiler         : C2C plus C-Compiler
//  Assembler        : MPLAB MPASMWIN from Microchip Technology, Inc.
//  Initial Date     : Aug 28, 2008
//  Last Update date : Aug 28, 2008 0.1
//  Tab size         : 3
//  Firmware Eng.    : WA7ZVY
//  HW Design Eng.   : WA7ZVY
// 
//  **********************************************************************
// 
// 	Modification History:
// 	=-=-=-=-=-=-=-=-=-=-=
//		08-28-08 pm - Initial creation.
// 	
// ***********************************************************************
// ***********************************************************************

// -----------------------------------------------------------------------
// Macros

// Very useful macro which allows use of predefined bit values from 'processor'.h
// to be used for testing bits just like they are used in set_bit and clear_bit
#define test_bit(x,y) (x&(1<<y))

#define test_bit_HI(x,y) ((x & (1<<y)) != 0)
#define test_bit_LO(x,y) ((x & (1<<y)) == 0)

// -----------------------------------------------------------------------

// ***********************************************************************
// ***********************************************************************
// Register Configurations
//
// ***********************************************************************
//		=== PORTA ===
// ***********************************************************************
#define	CFG_PORTA	0xFF		// Addr 0x05	
//												:7: high <Clock In Signal (optional)>
//												:6: high <WATCHDOG_ALIVE_LED Signal>
//												:5: high <Vpp Signal>
//												:4: high <PENDING_DOOM_LED Signal>
//												:3: high <AC_POWER_OFF_LED Signal>
//												:2: high <AC_POWER_ON_LED Signal>
//												:1: high <BOOT_WAIT_LED Signal>
//												:0: high <WATCHDOG_ARMED_LED Signal>
// ***********************************************************************
#define	CFG_CMCON	0x07		// Addr 0x1F
//												:7: low  <C2OUT>
//												:6: low  <C1OUT>
//												:5: low  <C2INV>
//												:4: low  <C1INV>
//												:3: low  <CIS>
//												:2: high <CM2> must be high to select digital I/O on PortA
//												:1: high <CM1> must be high to select digital I/O on PortA
//												:0: high <CM0> must be high to select digital I/O on PortA
// ***********************************************************************
#define	CFG_TRISA	0xA0		// Addr 0x85
//												:7: input  <Clock In Signal (optional)>
//												:6: output <WATCHDOG_ALIVE_LED Signal>
//												:5: input  <Vpp Signal>
//												:4: output <PENDING_DOOM_LED Signal>
//												:3: output <AC_POWER_OFF_LED Signal>
//												:2: output <AC_POWER_ON_LED Signal>
//												:1: output <BOOT_WAIT_LED Signal>
//												:0: output <WATCHDOG_ARMED_LED Signal>
// ***********************************************************************
// ***********************************************************************
//		=== PORTB ===
// ***********************************************************************
#define	CFG_PORTB	0xDB		// Addr 0x06
//												:7: high  <Programming Data Signal>
//												:6: high  <Programming Clock Signal>
//												:5: low   <AC_POWER_OFF Signal>
//												:4: high  <Programming Mode Signal>
//												:3: high  <BYPASS_L / FUTURE_1_LED Signal>
//												:2: low   <RS232 TX Data Signal (not used)>
//												:1: high  <HEARTBEAT Signal>
//												:0: high  <FUTURE_2_LED Signal>
// ***********************************************************************
#define	CFG_TRISB	0x0A		// Addr 0x86
//												:7: output  <Programming Data Signal>
//												:6: output  <Programming Clock Signal>
//												:5: output  <AC_POWER_OFF Signal>
//												:4: output  <Programming Mode Signal>
//												:3: input   <BYPASS_L / FUTURE_1_LED Signal>
//												:2: output  <RS232 TX Data Signal (not used)>
//												:1: input   <HEARTBEAT Signal (RS232 RX Data Signal)>
//												:0: output  <FUTURE_2_LED Signal>
// ***********************************************************************
// ***********************************************************************
//		=== OPTION REGISTER ===
// ***********************************************************************
#define	CFG_OPTION	0x80		// Addr 0x81
//												:7: PORTB pullups disabled
//												:6: <not used, see intcon register>
//												:5: TMR0 - internal clk
//												:4: <not used, see bit 5>
//												:3: PSA - prescaler assigned to Timer0
//												:2: PRESCALER = 1:2
//												:1: PRESCALER = 1:2
//												:0: PRESCALER = 1:2
// ***********************************************************************


// ***********************************************************************
#define	CFG_INTCON	0x00		// Addr 0x0B
//												:7: Disable ALL Interrupts
//												:6: Disable Peripheral Interrupts
//												:5: Disable TMR0 Overflow Interrupt
//												:4: Disable RB0/INT Interrupt
//												:3: Disable PORTB Change Interrupt
//												:2: TMR0 Overflow Flag
//												:1: RB0/INT Flag
//												:0: PORTB RB7:RB4 Change Flag
// ***********************************************************************
#define	CFG_PIR1	0x00		// Addr 0x0C
//												:7: Clears PSPIF
//												:6: Clears ADIF
//												:5: Clears RCIF
//												:4: Clears TXIF
//												:3: Clears SSPIF
//												:2: Clears CCP1IF
//												:1: Clears TMR2IF
//												:0: Clears TMR1IF
// ***********************************************************************
#define	CFG_PIE1	0x00		// Addr 0x8C
//												:7: Disables EE Write Complete Interrupt (EEIE)
//												:6: Disables Comparator Interrupt (CMIE)
//												:5: Disables USART RxD Interrupt (RCIE)
//												:4: Disables USART TxD Interrupt (TXIE)
//												:3: <undefined>
//												:2: Disables Capture Compare 1 Interrupt (CCP1IE)
//												:1: Disables Timer2 to PR2 Match Interrupt (TMR2IE)
//												:0: Disables Timer1 Overflow Interrupt (TMR1IE)
// ***********************************************************************
#define	CFG_PCON	0x08		// Addr 0x8E
//												:7: <undefined>
//												:6: <undefined>
//												:5: <undefined>
//												:4: <undefined>
//												:3: Oscillator Frequency 1=4MHz, 0=37KHz
//												:2: <undefined>
//												:1: Power On Reset Occurred (POR)
//												:0: Brown Out Reset Occurred (BOR)
// ***********************************************************************


// ***********************************************************************
// ***********************************************************************
// LED bit positions in the A Port registers
#define	PENDING_DOOM_LED	0x0004	// porta
#define	AC_POWER_OFF_LED	0x0003	// porta
#define	AC_POWER_ON_LED		0x0002	// porta
#define	BOOT_WAIT_LED		0x0001	// porta
#define	WATCHDOG_ARMED_LED	0x0000	// porta
#define	WATCHDOG_ALIVE_LED	0x0006	// porta
// LED bit positions in the B Port registers
#define	FUTURE_1_LED		0x0003	// portb
#define	FUTURE_2_LED		0x0000	// portb

// Control Signal bit positions in the B Port registers
#define	HEARTBEAT_SIG		0x0001	// portb
#define BYPASS_L_SIG		0x0003	// portb
#define	AC_POWER_OFF_SIG	0x0005	// portb

#define	HEARTBEAT_MASK		0x0002
#define BYPASS_L_MASK		0x0008


// ***********************************************************************

// End of File (micro_bits.h)
